﻿using System;
using System.Collections.Generic;
using System.Text;

using Thomas_Erdoesi.Game_Analyzer;

namespace Thomas_Erdoesi.Game_Objects
{
    public class Asteroid : GameObject
    {
        public GameObjectLocation DetectionLocation;
        public int DetectionFrame;

        public int Type;

        public int IncomingShots;

        public Asteroid(GameStatus Status, int x, int y, int size, int type)
            : base(x, y, size)
        {
            this.Type = type;

            DetectionLocation = new GameObjectLocation(x, y);
            DetectionFrame = Status.FrameCounter;

            IncomingShots = 0;
        }
    }
}
